/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.controller;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import pt.caf_pbs.schooldiskapi.dao.FilesOperation;
import pt.caf_pbs.schooldiskapi.dto.StudentDTO;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;
import pt.caf_pbs.schooldiskapi.model.Date;
import pt.caf_pbs.schooldiskapi.model.School;
import pt.caf_pbs.schooldiskapi.model.Student;

@RestController
@RequestMapping(value={"/v1/student"})
public class StudentsController {
    @PutMapping(value={"{id}"})
    public Student updateStudent(@PathVariable Integer id, @RequestBody StudentDTO studentDTO) {
        try {
            School school = FilesOperation.loadSchool();
            Date date = new Date(studentDTO.getBirthday().getDay(), studentDTO.getBirthday().getMonth(), studentDTO.getBirthday().getYear());
            school.getStudentContainer().update(id.intValue(), studentDTO.getName(), date);
            FilesOperation.storeSchool((School)school);
            return school.getStudentContainer().get(id.intValue());
        }
        catch (InvalidDataException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with " + e.getMessage(), (Throwable)e);
        }
    }

    @PostMapping
    public Student createStudent(@RequestBody StudentDTO studentDTO) {
        try {
            School school = FilesOperation.loadSchool();
            Date date = new Date(studentDTO.getBirthday().getDay(), studentDTO.getBirthday().getMonth(), studentDTO.getBirthday().getYear());
            Student newStudent = new Student(studentDTO.getName(), date);
            school.getStudentContainer().add(newStudent);
            FilesOperation.storeSchool((School)school);
            return newStudent;
        }
        catch (DuplicatedDataException | InvalidDataException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with " + e.getMessage(), e);
        }
    }

    @GetMapping(value={"{id}"})
    public Student getStudent(@PathVariable Integer id) {
        School school = FilesOperation.loadSchool();
        Student student = school.getStudentContainer().get(id.intValue());
        if (student != null) {
            return student;
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Student with id " + id + " found");
    }

    @DeleteMapping(value={"{id}"})
    public Student deleteStudent(@PathVariable Integer id) {
        School school = FilesOperation.loadSchool();
        Student student = school.getStudentContainer().get(id.intValue());
        if (student != null) {
            school.getStudentContainer().remove(id.intValue());
            FilesOperation.storeSchool((School)school);
            return student;
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Students with initials " + id + " found");
    }
}

